
/***********************************************************************************************
Expenditure descriptive statistics table
***********************************************************************************************/

# delimit;
capture log close;
capture program drop all;
clear;
clear matrix;
set more off;
set mem 500M;
estimates clear;
set matsize 2000;
set maxvar 32000;
version 10;

global data "C:/Users/nschwart/Desktop/nclb_final/ccd_folder/final_data";
global tables "C:/Users/nschwart/Desktop/nclb_final/ccd_folder/tables";

/*Collect outcomes*/
global expenditures "tcurelscpp tcurinstpp tcurssvcpp tcurothpp";
global revenues "total_rev tfedrevpp stlocrevpp";
global expenditures_log "logtcurelscpp logtcurinstpp logtcurssvcpp logtcurothpp";
global revenues_log "logtfedrevpp logtstrevpp logtlocrevpp";
 
 use "$data/dist_expend.dta", clear;
 gen total_rev = tfedrevpp+stlocrevpp;
 replace pct_bl_hisp = 100*pct_bl_hisp;
 
 estpost sum dist_enroll_hun pct_bl_hisp pov_rate_00 tcurelscpp tcurinstpp tcurssvcpp tcurothpp total_rev tfedrevpp stlocrevpp salary_2009 pup_tch 
 [aw=enrollment];
 estimates store full;
 foreach l in 1 2 3 4 {;
  estpost sum dist_enroll_hun pct_bl_hisp pov_rate_00 tcurelscpp tcurinstpp tcurssvcpp tcurothpp total_rev tfedrevpp stlocrevpp salary_2009 pup_tch
   if pov_quart==`l' [aw=enrollment];
  estimates store quart`l';
 };

estout * using "$tables/expend_descriptives.txt",   
cells(mean (fmt(2)))stats(N, fmt(0)) replace;
